
$TITLE  Glass Optim Case 3b: Linear or nonlin property models w/o uncert

$OFFUPPER OFFSYMXREF OFFSYMLIST

$ONTEXT
This file was last modified by Amit Goyal and Urmila Diwekar, 2000-2001
***********************************************************************
***********************************************************************
* NOTICE: The OWL models are undergoing continuing development.       *
* They have not been verified or validated, and software control      *
* procedures have not yet been implemented.  Any use of the results   *
* of this software are the sole responsibility of the user.  The      *
* developer of this software makes no claims as to the accuracy,      *
* completeness, or usefulness of information as a result of the       *
* software's use.                                                     *
***********************************************************************
***********************************************************************


MODEL DESCRIPTION


This is the base case (OWL-Base) formulation of the waste loading
maximization problem.  It uses linear or nonlinear glass property
models and does not take into account uncertainties in the models.  It
requires the following additional files.  Different versions of each
may exist, allowing flexibility in running different types of problems
without modifying the main model code.  The required files (and
different versions) are listed below:


  input.inc   - contains all changeable parameters except for waste
                 composition
  wastcomp.prn - a lotus 123 print file that contains waste composition
                 data (in a specific format)
  glmdl1.inc   - contains the coefficients for the glass property models
  calcspec.inc - contains the instructions for performing the
                 calculations, calculating additional information, and
                 printing output

$OFFTEXT

* Turn off equation listing in output
OPTION LIMROW = 0
OPTION LIMCOL = 0


* Define primary index variables ========================================

SETS
  Mstr  master set of all set elements
        /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3,
                 ZrO2, Other, Cr2O3, F, P2O5, SO3, NobMet, OxideMass  /
  Comp(Mstr) input file waste components and parameters
             /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3,
                 ZrO2, Other, Cr2O3, F, P2O5, SO3, NobMet, OxideMass  /
  C(Mstr)  all waste components tracked
           /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3,
                 ZrO2, Other, Cr2O3, F, P2O5, SO3, NobMet/
  I(Mstr)  waste components for glass property models
           /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3, ZrO2, Other/
  K(Mstr)  waste components for solubility constraints
           /Cr2O3, F, P2O5, SO3, NobMet/;

$ONTEXT
The waste components in set K are treated differently than those in set
I. They are included in the glass property models as part of Other.
Their only use is for solubility constraints (expressed as upper limits
on the variables).
$OFFTEXT

* Make index J equivalent to index I (necessary for matrix computations)
ALIAS (I,J);


* Declare Parameters and Variables ======================================

PARAMETERS
  FW(Mstr)   Mass fraction of each component in the waste
  Frit;

SCALARS

  MassOxide  total mass (kg) of oxides in waste
  NumCans    number of canisters of glass required
  Viscosity  PaS
  ElectCond  'S/m'
  BorDissPCT 'g/m2/day'
  BorDissMCC 'g/m2/day'
  CanMass    mass (kg) of glass per canister;

POSITIVE VARIABLES

  FG(Mstr)  Mass fraction of each component in the glass
  FF(Mstr)  Mass fraction of each component in the frit
  TMWG   Total mass (per canister) of waste in the glass (kg)
  TMFG   Total mass (per canister) of frit in the glass (kg)
  TMRG      for compatibility with recycle case display stmts
  RecyFrac  for compatibility with recycle case display stmts
  FR(Mstr)  for compatibility with recycle case display stmts
  Glass     Total mass of glass formed            ;


FREE VARIABLE

  WasteFrac  Fraction of mass of glass log that is waste ;


* Set values of scalars, parameters, variable bounds, initial values  ===

$include "input1.inc"


* Read PRN file with waste set declarations =============================
* and waste compositions

$include "wastcompnlp1.prn"


* Define glass property model coefficients ==============================

$include "glmdl.inc"


* Define equations and constraints ======================================

EQUATIONS
  WasteFract   defines mass fraction of waste glass - maximized variable
  FracSumF     sum of mass fractions in frit must = 1.0
  FracSumG     sum of mass fractions in glass must = 1.0
  GlassComp(C) calculate glass mass fractions for glass model components
  GlassMass    glass = waste + frit
  Crystal1     glass crystallinity constraint
  Crystal2     glass crystallinity constraint
  Crystal3     glass crystallinity constraint
  Crystal4     glass crystallinity constraint
  Crystal5     glass crystallinity constraint
  ViscLwr      viscosity greater than lower limit
  ViscUpr      viscosity less than upper limit
  ECondLwr     e-conductivity greater than lower limit
  ECondUpr     e-conductivity less than upper limit
  DissPCTbor   dissolution rate for boron by PCT test less than max allowable
  DissMCCbor   dissolution rate for boron by MCC test less than max allowable;

WasteFract ..      WasteFrac =E= TMWG/MaxLogMass ;

FracSumF ..        1.0 =E= SUM(I,FF(I));

FracSumG ..        1.0 =E= SUM(J,FG(J));

GlassComp(C) ..    FG(C) =E= (FF(C)*TMFG + FW(C)*TMWG)/MaxLogMass;

GlassMass ..       TMFG + TMWG =E= MaxLogMass;

Crystal1 .. FG('SiO2') =G= FG('Al2O3')*Cryst1Bnd;

Crystal2 .. FG('MgO')+FG('CaO') =L= Cryst2Bnd;

Crystal3 .. FG('Fe2O3')+FG('Al2O3')+FG('ZrO2')+FG('Other') =L= Cryst3Bnd;

Crystal4 .. FG('Al2O3')+FG('ZrO2') =L= Cryst4Bnd;

Crystal5 .. FG('MgO')+FG('CaO')+FG('ZrO2') =L= Cryst5Bnd  ;

ViscLwr ..  SUM(I,AV(I)*FG(I)) + SUM((I,J),BV(I,J)*FG(I)*FG(J))
                                                    =G= LOG(ViscMin) ;

ViscUpr ..  SUM(I,AV(I)*FG(I)) + SUM((I,J),BV(I,J)*FG(I)*FG(J))
                                                    =L= LOG(ViscMax) ;

ECondLwr .. SUM(I,AE(I)*FG(I)) + SUM((I,J),BE(I,J)*FG(I)*FG(J))
                                                    =G= LOG(ECondMin) ;

ECondUpr ..  SUM(I,AE(I)*FG(I)) + SUM((I,J),BE(I,J)*FG(I)*FG(J))
                                                    =L= LOG(ECondMax) ;

DissPCTbor.. SUM(I,ADPB(I)*FG(I)) + SUM((I,J),BDPB(I,J)*FG(I)*FG(J))
                                                    =L= LOG(DissMaxPCT) ;

DissMCCbor.. SUM(I,ADMB(I)*FG(I)) + SUM((I,J),BDMB(I,J)*FG(I)*FG(J))
                                                    =L= LOG(DissMaxMCC) ;

* Declare model name  ===================================================

MODEL WASTEOPTIM /ALL/;
WASTEOPTIM.OPTFILE = 1;


* Specify calculation sequence and solution method ======================

$include "calcspec1.inc"